const express = require('express');
const dotenv = require('dotenv');
const app = express();
const bodyParse = require('body-parser');
const https = require('https');
const fs = require('fs');

app.set('view engine', 'ejs');
app.set('views', __dirname+'/src'+'/views');
app.set('trust proxy', true);
app.use(bodyParse.urlencoded({
    extended: true,
       parameterLimit: 10000,
       limit: 1024 * 1024 * 10
  }));
app.use(bodyParse.json({limit: '50mb'}));
app.use(express.urlencoded({extended: true}));
app.use(express.json());
app.use(express.static('src/public'));

var rutas_coberturas = require('./src/routes/servicios/index');
var vistas = require('./src/routes/vistas/index');

dotenv.config({path: 'src/env/.env'});

var PORT = process.env.PORT

app.use('/servicios-datt/coberturas', rutas_coberturas);
app.use('/', vistas)


app.listen(PORT, async()=>{
    console.log('SERVIDOR INICIADO: ', PORT);
})

/*https.createServer({
    key: fs.readFileSync('/home/dattdev/ssl/keys/a38b5_ca481_2307a7d8ff77aa5dd372c252e6526886.key'),
    cert: fs.readFileSync('/home/dattdev/ssl/certs/coberturas_dattdev_app_a38b5_ca481_1714175999_e64966dbb81f57959eedb7bfcd86d8bf.crt')
  }, app).listen(PORT, function(){
    console.log("My HTTPS server listening on port " + PORT + "...");
});*/